/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import java.util.Comparator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.q_misc_util.my_util.BoxPredicateF;
import qouteall.q_misc_util.my_util.Plane;

@Environment(value=EnvType.CLIENT)
public class FrustumCuller {
    @Nullable
    private BoxPredicateF canDetermineInvisibleFunc;
    private double camX;
    private double camY;
    private double camZ;

    public void update(double cameraX, double cameraY, double cameraZ) {
        this.canDetermineInvisibleFunc = this.getCanDetermineInvisibleFunc(cameraX, cameraY, cameraZ);
        this.camX = cameraX;
        this.camY = cameraY;
        this.camZ = cameraZ;
    }

    public boolean canDetermineInvisibleWithCameraCoord(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (this.canDetermineInvisibleFunc == null) {
            return false;
        }
        return this.canDetermineInvisibleFunc.test(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean canDetermineInvisibleWithCameraCoord(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (this.canDetermineInvisibleFunc == null) {
            return false;
        }
        return this.canDetermineInvisibleFunc.test((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ);
    }

    public boolean canDetermineInvisibleWithWorldCoord(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (this.canDetermineInvisibleFunc == null) {
            return false;
        }
        return this.canDetermineInvisibleWithCameraCoord(minX - this.camX, minY - this.camY, minZ - this.camZ, maxX - this.camX, maxY - this.camY, maxZ - this.camZ);
    }

    @Nullable
    private BoxPredicateF getCanDetermineInvisibleFunc(double cameraX, double cameraY, double cameraZ) {
        if (!IPCGlobal.doUseAdvancedFrustumCulling) {
            return null;
        }
        if (IrisInterface.invoker.isRenderingShadowMap()) {
            return null;
        }
        if (PortalRendering.isRendering()) {
            Portal renderingPortal = PortalRendering.getRenderingPortal();
            return renderingPortal.getPortalShape().getInnerFrustumCullingFunc(renderingPortal, new class_243(cameraX, cameraY, cameraZ));
        }
        if (!IPCGlobal.useSuperAdvancedFrustumCulling) {
            return null;
        }
        if (!SodiumInterface.invoker.isSodiumPresent()) {
            return null;
        }
        Portal portal = FrustumCuller.getCurrentNearestVisibleCullablePortal();
        if (portal != null) {
            return portal.getPortalShape().getOuterFrustumCullingFunc(portal, new class_243(cameraX, cameraY, cameraZ));
        }
        return null;
    }

    @Nullable
    private static Portal getCurrentNearestVisibleCullablePortal() {
        if (TransformationManager.isIsometricView) {
            return null;
        }
        class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
        return CHelper.getClientNearbyPortals(16.0).filter(portal -> portal.isInFrontOfPortal(cameraPos)).filter(Portal::canDoOuterFrustumCulling).min(Comparator.comparingDouble(portal -> portal.getDistanceToNearestPointInPortal(cameraPos))).orElse(null);
    }

    public static class_243[] getRectPortalFourVerticesCounterClockwise(UnilateralPortalState thisSideState) {
        double halfWidth = thisSideState.width() / 2.0;
        double halfHeight = thisSideState.height() / 2.0;
        return new class_243[]{thisSideState.transformLocalToGlobal(halfWidth, -halfHeight, 0.0), thisSideState.transformLocalToGlobal(halfWidth, halfHeight, 0.0), thisSideState.transformLocalToGlobal(-halfWidth, halfHeight, 0.0), thisSideState.transformLocalToGlobal(-halfWidth, -halfHeight, 0.0)};
    }

    public static Frustum4Planes getFrustumPlanesFromFourVerticesCounterClockwise(class_243[] vertices) {
        class_243 normal0 = vertices[1].method_1036(vertices[0]).method_1029();
        class_243 normal1 = vertices[2].method_1036(vertices[1]).method_1029();
        class_243 normal2 = vertices[3].method_1036(vertices[2]).method_1029();
        class_243 normal3 = vertices[0].method_1036(vertices[3]).method_1029();
        return new Frustum4Planes((float)normal0.field_1352, (float)normal0.field_1351, (float)normal0.field_1350, 0.0f, (float)normal1.field_1352, (float)normal1.field_1351, (float)normal1.field_1350, 0.0f, (float)normal2.field_1352, (float)normal2.field_1351, (float)normal2.field_1350, 0.0f, (float)normal3.field_1352, (float)normal3.field_1351, (float)normal3.field_1350, 0.0f);
    }

    public static BoxPredicateF getFlatPortalInnerFrustumCullingFunc(Portal portal, class_243 cameraPos) {
        class_243[] v = FrustumCuller.getRectPortalFourVerticesCounterClockwise(portal.getThisSideState());
        class_243[] vTransformed = new class_243[]{portal.transformPoint(v[0]).method_1020(cameraPos), portal.transformPoint(v[1]).method_1020(cameraPos), portal.transformPoint(v[2]).method_1020(cameraPos), portal.transformPoint(v[3]).method_1020(cameraPos)};
        if (portal instanceof Mirror) {
            vTransformed = new class_243[]{vTransformed[3], vTransformed[2], vTransformed[1], vTransformed[0]};
        }
        Frustum4Planes fourPlanes = FrustumCuller.getFrustumPlanesFromFourVerticesCounterClockwise(vTransformed);
        return fourPlanes::isFullyOutside;
    }

    public static BoxPredicateF getFlatPortalOuterFrustumCullingFunc(Portal portal, class_243 cameraPos) {
        class_243[] v = FrustumCuller.getRectPortalFourVerticesCounterClockwise(portal.getThisSideState());
        class_243[] vTransformed = new class_243[]{v[0].method_1020(cameraPos), v[1].method_1020(cameraPos), v[2].method_1020(cameraPos), v[3].method_1020(cameraPos)};
        Frustum4Planes fourPlanes = FrustumCuller.getFrustumPlanesFromFourVerticesCounterClockwise(vTransformed);
        Plane portalPlane = new Plane(portal.getOriginPos().method_1020(cameraPos), portal.getNormal());
        float portalPlaneX = (float)portalPlane.getEquationX();
        float portalPlaneY = (float)portalPlane.getEquationY();
        float portalPlaneZ = (float)portalPlane.getEquationZ();
        float portalPlaneW = (float)portalPlane.getEquationW();
        return (minX, minY, minZ, maxX, maxY, maxZ) -> {
            boolean a = FrustumCuller.isFullyBehindPlane(minX, minY, minZ, maxX, maxY, maxZ, portalPlaneX, portalPlaneY, portalPlaneZ, portalPlaneW);
            boolean b = fourPlanes.isFullyInside(minX, minY, minZ, maxX, maxY, maxZ);
            return a && b;
        };
    }

    public static boolean isFullyInFrontOfPlane(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float planeX, float planeY, float planeZ, float planeW) {
        float testingBoxX = planeX > 0.0f ? minX : maxX;
        float testingBoxY = planeY > 0.0f ? minY : maxY;
        float testingBoxZ = planeZ > 0.0f ? minZ : maxZ;
        return testingBoxX * planeX + testingBoxY * planeY + testingBoxZ * planeZ + planeW > 0.0f;
    }

    public static boolean isFullyBehindPlane(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float planeX, float planeY, float planeZ, float planeW) {
        float testingBoxX = planeX > 0.0f ? maxX : minX;
        float testingBoxY = planeY > 0.0f ? maxY : minY;
        float testingBoxZ = planeZ > 0.0f ? maxZ : minZ;
        return testingBoxX * planeX + testingBoxY * planeY + testingBoxZ * planeZ + planeW < 0.0f;
    }

    @Deprecated
    public static BatchTestResult testBoxTwoVertices(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double planeNormalX, double planeNormalY, double planeNormalZ, double planePosX, double planePosY, double planePosZ) {
        double p2z;
        double p1z;
        double p2y;
        double p1y;
        double p2x;
        double p1x;
        if (planeNormalX > 0.0) {
            p1x = minX;
            p2x = maxX;
        } else {
            p1x = maxX;
            p2x = minX;
        }
        if (planeNormalY > 0.0) {
            p1y = minY;
            p2y = maxY;
        } else {
            p1y = maxY;
            p2y = minY;
        }
        if (planeNormalZ > 0.0) {
            p1z = minZ;
            p2z = maxZ;
        } else {
            p1z = maxZ;
            p2z = minZ;
        }
        boolean r1 = FrustumCuller.isInFrontOf(p1x - planePosX, p1y - planePosY, p1z - planePosZ, planeNormalX, planeNormalY, planeNormalZ);
        boolean r2 = FrustumCuller.isInFrontOf(p2x - planePosX, p2y - planePosY, p2z - planePosZ, planeNormalX, planeNormalY, planeNormalZ);
        if (r1 && r2) {
            return BatchTestResult.all_true;
        }
        if (!r1 && !r2) {
            return BatchTestResult.all_false;
        }
        return BatchTestResult.both;
    }

    @Deprecated
    public static BatchTestResult testBoxTwoVertices(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, class_243 planeNormal) {
        return FrustumCuller.testBoxTwoVertices(minX, minY, minZ, maxX, maxY, maxZ, planeNormal.field_1352, planeNormal.field_1351, planeNormal.field_1350, 0.0, 0.0, 0.0);
    }

    @Deprecated
    private static boolean isInFrontOf(double x, double y, double z, double planeNormalX, double planeNormalY, double planeNormalZ) {
        return x * planeNormalX + y * planeNormalY + z * planeNormalZ >= 0.0;
    }

    public record Frustum4Planes(float p0X, float p0Y, float p0Z, float p0W, float p1X, float p1Y, float p1Z, float p1W, float p2X, float p2Y, float p2Z, float p2W, float p3X, float p3Y, float p3Z, float p3W) {
        public boolean isFullyOutside(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            return FrustumCuller.isFullyBehindPlane(minX, minY, minZ, maxX, maxY, maxZ, this.p0X, this.p0Y, this.p0Z, this.p0W) || FrustumCuller.isFullyBehindPlane(minX, minY, minZ, maxX, maxY, maxZ, this.p1X, this.p1Y, this.p1Z, this.p1W) || FrustumCuller.isFullyBehindPlane(minX, minY, minZ, maxX, maxY, maxZ, this.p2X, this.p2Y, this.p2Z, this.p2W) || FrustumCuller.isFullyBehindPlane(minX, minY, minZ, maxX, maxY, maxZ, this.p3X, this.p3Y, this.p3Z, this.p3W);
        }

        public boolean isFullyInside(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            return FrustumCuller.isFullyInFrontOfPlane(minX, minY, minZ, maxX, maxY, maxZ, this.p0X, this.p0Y, this.p0Z, this.p0W) && FrustumCuller.isFullyInFrontOfPlane(minX, minY, minZ, maxX, maxY, maxZ, this.p1X, this.p1Y, this.p1Z, this.p1W) && FrustumCuller.isFullyInFrontOfPlane(minX, minY, minZ, maxX, maxY, maxZ, this.p2X, this.p2Y, this.p2Z, this.p2W) && FrustumCuller.isFullyInFrontOfPlane(minX, minY, minZ, maxX, maxY, maxZ, this.p3X, this.p3Y, this.p3Z, this.p3W);
        }
    }

    @Deprecated
    public static enum BatchTestResult {
        all_true,
        all_false,
        both;

    }
}

